﻿#include  "StdAfx.h"

#include  "szFilePropertyInfo.hpp"

SZ_NS_BEG(szpp)

FilePropertyInfo::FilePropertyInfo() : idList()
{
}

FilePropertyInfo::~FilePropertyInfo()
{
}

void FilePropertyInfo::AddProperty(PROPID propID)
{
  if(std::find(idList.begin(), idList.end(), propID) != idList.end())
    return;

  idList.push_back(propID);

  switch (propID)
  {
  case kpidPath:            hasPath = true;       break;
  case kpidSize:            hasActualSize = true; break;
  case kpidPackSize:        hasStoredSize = true; break;
  case kpidAttrib:          hasAttributes = true; break;
  case kpidCTime:           hasCreated = true;    break;
  case kpidATime:           hasAccessed = true;   break;
  case kpidMTime:           hasModified = true;   break;

  case kpidIsDir:           hasIsDir = true;   break;
  }
}

SZ_NS_END(szpp)
